/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.token.IzoniInsectToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class GristThePlagueSwarmPlus1Effect
extends OneShotEffect {
    GristThePlagueSwarmPlus1Effect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create a 1/1 black and green Insect creature token, then mill two cards. Put a deathtouch counter on the token if a black card was milled this way.";
    }

    private GristThePlagueSwarmPlus1Effect(GristThePlagueSwarmPlus1Effect effect) {
        super((OneShotEffect)effect);
    }

    public GristThePlagueSwarmPlus1Effect copy() {
        return new GristThePlagueSwarmPlus1Effect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CreateTokenEffect effect = new CreateTokenEffect((Token)new IzoniInsectToken());
        effect.apply(game, source);
        Cards cards = controller.millCards(2, source, game);
        if (cards.getCards(game).stream().anyMatch(card -> card.getColor(game).isBlack())) {
            List tokens = effect.getLastAddedTokenIds().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
            if (!tokens.isEmpty()) {
                AddCountersTargetEffect addEffect = new AddCountersTargetEffect(CounterType.DEATHTOUCH.createInstance());
                addEffect.setTargetPointer((TargetPointer)new FixedTargets(tokens, game));
                addEffect.apply(game, source);
            }
        }
        return true;
    }
}

