/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Map;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.g.GrothamaAllDevouringWatcher;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class GrothamaAllDevouringDrawCardsEffect
extends OneShotEffect {
    GrothamaAllDevouringDrawCardsEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player draws cards equal to the amount of damage dealt to {this} this turn by sources they controlled.";
    }

    private GrothamaAllDevouringDrawCardsEffect(GrothamaAllDevouringDrawCardsEffect effect) {
        super((OneShotEffect)effect);
    }

    public GrothamaAllDevouringDrawCardsEffect copy() {
        return new GrothamaAllDevouringDrawCardsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        GrothamaAllDevouringWatcher watcher = (GrothamaAllDevouringWatcher)game.getState().getWatcher(GrothamaAllDevouringWatcher.class);
        if (watcher == null) {
            return false;
        }
        Map<UUID, Integer> damageMap = watcher.getDamageMap(new MageObjectReference(source.getSourceId(), source.getStackMomentSourceZCC() - 1, game));
        for (UUID playerId : game.getPlayerList()) {
            int toDraw;
            Player player = game.getPlayer(playerId);
            if (player == null || (toDraw = damageMap.getOrDefault(player.getId(), 0).intValue()) <= 0) continue;
            player.drawCards(toDraw, source, game);
        }
        return true;
    }
}

