/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GrowthSpurtEffect
extends OneShotEffect {
    GrowthSpurtEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Roll a six-sided die. Target creature gets +X/+X until end of turn, where X is the result";
    }

    private GrowthSpurtEffect(GrowthSpurtEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int result = controller.rollDice(this.outcome, source, game, 6);
            Permanent permanent = game.getPermanent(source.getFirstTarget());
            if (permanent != null) {
                BoostTargetEffect effect = new BoostTargetEffect(result, result, Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
        }
        return false;
    }

    public GrowthSpurtEffect copy() {
        return new GrowthSpurtEffect(this);
    }
}

