/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageAllEffect;
import mage.abilities.effects.common.combat.CantBlockAllEffect;
import mage.abilities.effects.common.continuous.GainControlAllEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;

public final class GruulCharm
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creatures without flying");
    private static final FilterPermanent filter2 = new FilterPermanent("permanents you own");

    public GruulCharm(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{R}{G}");
        this.getSpellAbility().addEffect((Effect)new CantBlockAllEffect(filter, Duration.EndOfTurn));
        this.getSpellAbility().addMode(new Mode((Effect)new GainControlAllEffect(Duration.Custom, filter2)));
        this.getSpellAbility().addMode(new Mode((Effect)new DamageAllEffect(3, (FilterPermanent)StaticFilters.FILTER_CREATURE_FLYING)));
    }

    private GruulCharm(GruulCharm card) {
        super((CardImpl)card);
    }

    public GruulCharm copy() {
        return new GruulCharm(this);
    }

    static {
        filter.add(Predicates.not((Predicate)new AbilityPredicate(FlyingAbility.class)));
        filter2.add((ObjectSourcePlayerPredicate)TargetController.YOU.getOwnerPredicate());
    }
}

