/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.TapTargetEffect;
import mage.cards.g.GuardianOfTazeemEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GuardianOfTazeemTriggeredAbility
extends TriggeredAbilityImpl {
    public GuardianOfTazeemTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new TapTargetEffect(), false);
        this.addEffect((Effect)new GuardianOfTazeemEffect());
        this.setTriggerPhrase("<i>Landfall</i> &mdash; Whenever a land you control enters, ");
    }

    private GuardianOfTazeemTriggeredAbility(GuardianOfTazeemTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public GuardianOfTazeemTriggeredAbility copy() {
        return new GuardianOfTazeemTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null && permanent.isLand(game) && permanent.isControlledBy(this.getControllerId())) {
            for (Effect effect : this.getEffects()) {
                if (!(effect instanceof GuardianOfTazeemEffect)) continue;
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            }
            return true;
        }
        return false;
    }
}

