/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.g.GuardianProjectTriggeredAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GuardianProjectEffect
extends OneShotEffect {
    private final MageObjectReference mor;

    GuardianProjectEffect(MageObjectReference mor) {
        super(Outcome.Benefit);
        this.mor = mor;
    }

    private GuardianProjectEffect(GuardianProjectEffect effect) {
        super((OneShotEffect)effect);
        this.mor = effect.mor;
    }

    public GuardianProjectEffect copy() {
        return new GuardianProjectEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = this.mor.getPermanentOrLKIBattlefield(game);
        if (player == null || permanent == null) {
            return false;
        }
        if (GuardianProjectTriggeredAbility.checkCondition(permanent, source.getControllerId(), game)) {
            player.drawCards(1, source, game);
            return true;
        }
        return false;
    }
}

