/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.util.CardUtil;

class GuffRewritesHistoryEffect
extends OneShotEffect {
    GuffRewritesHistoryEffect() {
        super(Outcome.Neutral);
    }

    private GuffRewritesHistoryEffect(GuffRewritesHistoryEffect effect) {
        super((OneShotEffect)effect);
    }

    public GuffRewritesHistoryEffect copy() {
        return new GuffRewritesHistoryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet<UUID> controllers = new HashSet<UUID>();
        HashMap<UUID, Cards> toShuffle = new HashMap<UUID, Cards>();
        for (Target target : source.getTargets()) {
            for (UUID permId : target.getTargets()) {
                Permanent permanent = game.getPermanent(permId);
                if (permanent == null) continue;
                Player owner = game.getPlayer(permanent.getOwnerId());
                Player controller = game.getPlayer(permanent.getControllerId());
                if (controller != null) {
                    controllers.add(controller.getId());
                }
                if (owner == null) continue;
                toShuffle.computeIfAbsent(owner.getId(), k -> new CardsImpl());
                ((Cards)toShuffle.get(owner.getId())).add((Card)permanent);
            }
        }
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            if (!toShuffle.containsKey(playerId)) continue;
            Player owner = game.getPlayer(playerId);
            owner.shuffleCardsToLibrary((Cards)toShuffle.get(playerId), game, source);
        }
        HashMap<UUID, Card> nonlands = new HashMap<UUID, Card>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player controller;
            if (!controllers.contains(playerId) || (controller = game.getPlayer(playerId)) == null) continue;
            CardsImpl cards = new CardsImpl();
            Card nonland = null;
            for (Card card : controller.getLibrary().getCards(game)) {
                cards.add(card);
                if (card.isLand(game)) continue;
                nonland = card;
                break;
            }
            controller.moveCards((Cards)cards, Zone.EXILED, source, game);
            cards.retainZone(Zone.EXILED, game);
            controller.revealCards(source, " \u2014 " + controller.getName(), (Cards)cards, game);
            if (nonland != null && cards.contains((Object)nonland.getId())) {
                nonlands.put(playerId, nonland);
                cards.remove(nonland);
            }
            controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        }
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            if (!nonlands.containsKey(playerId)) continue;
            Player player = game.getPlayer(playerId);
            Card card = (Card)nonlands.get(playerId);
            if (player == null || card == null) continue;
            CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Card)card);
        }
        return true;
    }
}

