/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class GuidingSpiritEffect
extends OneShotEffect {
    GuidingSpiritEffect() {
        super(Outcome.Benefit);
        this.staticText = "If the top card of target player's graveyard is a creature card, put that card on top of that player's library.";
    }

    private GuidingSpiritEffect(GuidingSpiritEffect effect) {
        super((OneShotEffect)effect);
    }

    public GuidingSpiritEffect copy() {
        return new GuidingSpiritEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        Card card = player.getGraveyard().getTopCard(game);
        if (card != null && card.isCreature(game)) {
            player.putCardsOnTopOfLibrary((Cards)new CardsImpl(card), game, source, false);
        }
        return true;
    }
}

