/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GwafaHazidProfiteerEffect
extends RestrictionEffect {
    GwafaHazidProfiteerEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "Creatures with bribery counters on them can't attack or block";
    }

    private GwafaHazidProfiteerEffect(GwafaHazidProfiteerEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getCounters(game).containsKey(CounterType.BRIBERY);
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public GwafaHazidProfiteerEffect copy() {
        return new GwafaHazidProfiteerEffect(this);
    }
}

