/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.ExploreSourceEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class HakbalOfTheSurgingSoulExploreEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent(SubType.MERFOLK);

    HakbalOfTheSurgingSoulExploreEffect() {
        super(Outcome.Benefit);
        this.staticText = "each Merfolk creature you control explores";
    }

    HakbalOfTheSurgingSoulExploreEffect(HakbalOfTheSurgingSoulExploreEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        List creatures = game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game);
        Player player = game.getPlayer(source.getControllerId());
        if (player != null && player.chooseUse(Outcome.AIDontUseIt, "Choose order for Merfolk to explore? (Note: You will need to set \"Auto-choose targets for player:\" to \"Off\" in Preferences.)", source, game)) {
            TargetPermanent target = new TargetPermanent(creatures.size(), creatures.size(), filter, true);
            target.withChooseHint("the order in which to explore (first selected will explore first)");
            player.choose(this.outcome, (Target)target, source, game);
            for (UUID targetId : target.getTargets()) {
                ExploreSourceEffect.explorePermanent((Game)game, (UUID)targetId, (Ability)source, (int)1);
            }
        } else {
            for (Permanent creature : creatures) {
                ExploreSourceEffect.explorePermanent((Game)game, (UUID)creature.getId(), (Ability)source, (int)1);
            }
        }
        return true;
    }

    public HakbalOfTheSurgingSoulExploreEffect copy() {
        return new HakbalOfTheSurgingSoulExploreEffect(this);
    }
}

