/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.CardType;
import mage.constants.PhaseStep;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

enum HakimLoreweaverCondition implements Condition
{
    instance;

    private static final FilterPermanent auras;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean apply(Game game, Ability source) {
        if (PhaseStep.UPKEEP != game.getTurnStepType()) return false;
        if (!game.isActivePlayer(source.getControllerId())) {
            return false;
        }
        Permanent hakimLoreweaver = source.getSourcePermanentIfItStillExists(game);
        if (hakimLoreweaver == null) return false;
        if (!hakimLoreweaver.getAttachments().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).noneMatch(permanent -> permanent.hasSubtype(SubType.AURA, game))) return false;
        return true;
    }

    public String toString() {
        return "during your upkeep and only if {this} isn't enchanted";
    }

    static {
        auras = new FilterPermanent();
        auras.add((Predicate)CardType.ENCHANTMENT.getPredicate());
    }
}

