/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.p.PakoArcaneRetriever;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;

class HaldanAvidArcanistCastFromExileEffect
extends AsThoughEffectImpl {
    HaldanAvidArcanistCastFromExileEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.Custom, Outcome.Benefit);
        this.staticText = "You may play noncreature cards from exile with fetch counters on them if you exiled them";
    }

    private HaldanAvidArcanistCastFromExileEffect(HaldanAvidArcanistCastFromExileEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public HaldanAvidArcanistCastFromExileEffect copy() {
        return new HaldanAvidArcanistCastFromExileEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        Card card = game.getCard(sourceId);
        if (card == null || !source.isControlledBy(affectedControllerId) || game.getState().getZone(sourceId) != Zone.EXILED || !PakoArcaneRetriever.checkWatcher(affectedControllerId, card, game)) {
            return false;
        }
        return !card.isCreature(game) && card.getCounters(game).containsKey(CounterType.FETCH);
    }
}

