/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectData;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.players.Player;

class HallowPreventDamageByTargetEffect
extends PreventionEffectImpl {
    HallowPreventDamageByTargetEffect(Duration duration) {
        super(duration, Integer.MAX_VALUE, false);
        this.staticText = "Prevent all damage target spell would deal this turn. You gain life equal to the damage prevented this way";
    }

    private HallowPreventDamageByTargetEffect(HallowPreventDamageByTargetEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public HallowPreventDamageByTargetEffect copy() {
        return new HallowPreventDamageByTargetEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        PreventionEffectData preventionEffectData = this.preventDamageAction(event, source, game);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.gainLife(preventionEffectData.getPreventedDamage(), game, source);
        }
        return true;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject mageObject;
        if (!this.used && super.applies(event, source, game) && (mageObject = game.getObject(event.getSourceId())) instanceof Spell) {
            return this.getTargetPointer().getTargets(game, source).contains(mageObject.getId());
        }
        return false;
    }
}

