/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HallowedRespiteEffect
extends OneShotEffect {
    HallowedRespiteEffect() {
        super(Outcome.Benefit);
        this.staticText = "If it entered under your control, put a +1/+1 counter on it. Otherwise, tap it";
    }

    private HallowedRespiteEffect(HallowedRespiteEffect effect) {
        super((OneShotEffect)effect);
    }

    public HallowedRespiteEffect copy() {
        return new HallowedRespiteEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        if (permanent.isControlledBy(source.getControllerId())) {
            permanent.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
        } else {
            permanent.tap(source, game);
        }
        return true;
    }
}

