/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class HaloChargedSkaabEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("instant, sorcery, or battle card from your graveyard");

    HaloChargedSkaabEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then you may put an instant, sorcery, or battle card from your graveyard on top of your library";
    }

    private HaloChargedSkaabEffect(HaloChargedSkaabEffect effect) {
        super((OneShotEffect)effect);
    }

    public HaloChargedSkaabEffect copy() {
        return new HaloChargedSkaabEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, 1, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && player.putCardsOnTopOfLibrary(card, game, source, false);
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.INSTANT.getPredicate(), CardType.SORCERY.getPredicate(), CardType.BATTLE.getPredicate()}));
    }
}

