/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HalsinEmeraldArchdruidEffect
extends ContinuousEffectImpl {
    HalsinEmeraldArchdruidEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "until end of turn, target token you control becomes a green Bear creature with base power and toughness 4/4 in addition to its other colors and types";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private HalsinEmeraldArchdruidEffect(HalsinEmeraldArchdruidEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public HalsinEmeraldArchdruidEffect copy() {
        return new HalsinEmeraldArchdruidEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            this.discard();
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.addCardType(game, new CardType[]{CardType.CREATURE});
                permanent.addSubType(game, new SubType[]{SubType.BEAR});
                return true;
            }
            case ColorChangingEffects_5: {
                permanent.getColor(game).setGreen(true);
                return true;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                permanent.getPower().setModifiedBaseValue(4);
                permanent.getToughness().setModifiedBaseValue(4);
                return true;
            }
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case TypeChangingEffects_4: 
            case ColorChangingEffects_5: 
            case PTChangingEffects_7: {
                return true;
            }
        }
        return false;
    }
}

