/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HammerHelperEffect
extends OneShotEffect {
    HammerHelperEffect() {
        super(Outcome.Benefit);
        this.staticText = "Gain control of target creature until end of turn. Untap that creature and roll a six-sided die. Until end of turn, it gains haste and gets +X/+0, where X is the result";
    }

    private HammerHelperEffect(HammerHelperEffect effect) {
        super((OneShotEffect)effect);
    }

    public HammerHelperEffect copy() {
        return new HammerHelperEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent targetCreature = game.getPermanent(source.getFirstTarget());
        if (controller != null && targetCreature != null) {
            ((Effect)source.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(targetCreature.getId(), game));
            game.addEffect((ContinuousEffect)new GainControlTargetEffect(Duration.EndOfTurn), source);
            game.processAction();
            targetCreature.untap(game);
            int amount = controller.rollDice(this.outcome, source, game, 6);
            game.addEffect((ContinuousEffect)new BoostTargetEffect(amount, 0, Duration.EndOfTurn), source);
            game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn), source);
            return true;
        }
        return false;
    }
}

