/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HammerJammerEffect
extends OneShotEffect {
    HammerJammerEffect() {
        super(Outcome.Benefit);
        this.staticText = "remove all +1/+1 counters from {this}, then put a number of +1/+1 counters on it equal to the result";
    }

    private HammerJammerEffect(HammerJammerEffect effect) {
        super((OneShotEffect)effect);
    }

    public HammerJammerEffect copy() {
        return new HammerJammerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Integer amount;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (controller != null && permanent != null && (amount = (Integer)this.getValue("rolled")) != null) {
            permanent.removeAllCounters(CounterType.P1P1.getName(), source, game);
            if (amount > 0) {
                permanent.addCounters(CounterType.P1P1.createInstance(amount.intValue()), source.getControllerId(), source, game);
            }
            return true;
        }
        return false;
    }
}

