/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Iterator;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.LandwalkAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HammerheimEffect
extends ContinuousEffectImpl {
    HammerheimEffect() {
        super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.LoseAbility);
        this.staticText = "Target creature loses all landwalk abilities until end of turn.";
    }

    private HammerheimEffect(HammerheimEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public HammerheimEffect copy() {
        return new HammerheimEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            Iterator iter = permanent.getAbilities().iterator();
            while (iter.hasNext()) {
                Ability ab = (Ability)iter.next();
                if (!(ab instanceof LandwalkAbility)) continue;
                iter.remove();
            }
        }
        return true;
    }
}

