/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.List;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.MageObjectReferencePredicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HandOfVecnaEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("creature you control named Vecna");

    HandOfVecnaEffect() {
        super(Outcome.Benefit);
        this.staticText = "equipped creature or a creature you control named Vecna gets +X/+X until end of turn, where X is the number of cards in your hand";
    }

    private HandOfVecnaEffect(HandOfVecnaEffect effect) {
        super((OneShotEffect)effect);
    }

    public HandOfVecnaEffect copy() {
        return new HandOfVecnaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent toBoost;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getHand().size() < 1) {
            return false;
        }
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        Permanent equipped = game.getPermanent(sourcePermanent != null ? sourcePermanent.getAttachedTo() : null);
        List chooseable = game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game);
        if (equipped != null) {
            chooseable.add(equipped);
        }
        switch (chooseable.size()) {
            case 0: {
                return false;
            }
            case 1: {
                toBoost = (Permanent)chooseable.get(0);
                break;
            }
            default: {
                FilterPermanent filter = new FilterPermanent("a creature to give +X/+X to");
                filter.add(Predicates.or((Iterable)chooseable.stream().map(permanent -> new MageObjectReferencePredicate((MageObject)permanent, game)).collect(Collectors.toList())));
                TargetPermanent target = new TargetPermanent(filter);
                target.withNotTarget(true);
                player.choose(this.outcome, (Target)target, source, game);
                toBoost = game.getPermanent(target.getFirstTarget());
            }
        }
        int xValue = player.getHand().size();
        game.addEffect(new BoostTargetEffect(xValue, xValue, Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(toBoost, game)), source);
        return true;
    }

    static {
        filter.add((Predicate)new NamePredicate("Vecna"));
    }
}

