/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.FightTargetSourceEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterPlayerOrPlaneswalker;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.other.PlayerIdPredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetPlayerOrPlaneswalker;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class HansErikssonEffect
extends OneShotEffect {
    HansErikssonEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top card of your library. If it's a creature card, put it onto the battlefield tapped and attacking defending player or a planeswalker they control. Otherwise, put that card into your hand. When you put a creature card onto the battlefield this way, it fights {this}";
    }

    private HansErikssonEffect(HansErikssonEffect effect) {
        super((OneShotEffect)effect);
    }

    public HansErikssonEffect copy() {
        return new HansErikssonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID defenderId;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        if (!card.isCreature(game)) {
            return player.moveCards(card, Zone.HAND, source, game);
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return true;
        }
        UUID defendingPlayerId = this.getTargetPointer().getFirst(game, source);
        if (game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_PLANESWALKER, defendingPlayerId, source, game) < 1) {
            defenderId = defendingPlayerId;
        } else {
            FilterPlayerOrPlaneswalker filter = new FilterPlayerOrPlaneswalker("defending player or a planeswalker they control");
            filter.getPlayerFilter().add((Predicate)new PlayerIdPredicate(defendingPlayerId));
            filter.getPermanentFilter().add((Predicate)new ControllerIdPredicate(defendingPlayerId));
            TargetPlayerOrPlaneswalker target = new TargetPlayerOrPlaneswalker(filter);
            target.withNotTarget(true);
            player.choose(this.outcome, (Target)target, source, game);
            defenderId = target.getFirstTarget();
        }
        if (defenderId != null) {
            game.getCombat().addAttackerToCombat(permanent.getId(), defenderId, game);
        }
        FightTargetSourceEffect fightEffect = new FightTargetSourceEffect();
        fightEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)fightEffect, false, "When you put a creature card onto the battlefield this way, it fights {this}");
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

