/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetOpponentsCreaturePermanent;

class HaraldUnitesTheElvesTriggeredAbility
extends DelayedTriggeredAbility {
    HaraldUnitesTheElvesTriggeredAbility() {
        super((Effect)new BoostTargetEffect(-1, -1), Duration.EndOfTurn, false);
        this.addTarget((Target)new TargetOpponentsCreaturePermanent());
    }

    private HaraldUnitesTheElvesTriggeredAbility(HaraldUnitesTheElvesTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public HaraldUnitesTheElvesTriggeredAbility copy() {
        return new HaraldUnitesTheElvesTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getSourceId());
        return permanent != null && permanent.isControlledBy(this.getControllerId()) && permanent.hasSubtype(SubType.ELF, game);
    }

    public String getRule() {
        return "Whenever an Elf you control attacks this turn, target creature an opponent controls gets -1/-1 until end of turn.";
    }
}

