/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class HarborGuardianEffect
extends OneShotEffect {
    HarborGuardianEffect() {
        super(Outcome.DrawCard);
        this.staticText = "defending player may draw a card";
    }

    private HarborGuardianEffect(HarborGuardianEffect effect) {
        super((OneShotEffect)effect);
    }

    public HarborGuardianEffect copy() {
        return new HarborGuardianEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID defenderId = game.getCombat().getDefenderId(source.getSourceId());
        Player defender = game.getPlayer(defenderId);
        if (defender != null && defender.chooseUse(this.outcome, "Draw a card?", source, game)) {
            defender.drawCards(1, source, game);
        }
        return false;
    }
}

