/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HarborSerpentEffect
extends RestrictionEffect {
    private static final FilterLandPermanent filter = new FilterLandPermanent(SubType.ISLAND, "Island");

    public HarborSerpentEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack unless there are five or more Islands on the battlefield";
    }

    private HarborSerpentEffect(HarborSerpentEffect effect) {
        super((RestrictionEffect)effect);
    }

    public HarborSerpentEffect copy() {
        return new HarborSerpentEffect(this);
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId()) && game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game) < 5;
    }
}

