/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class HarnessInfinityEffect
extends OneShotEffect {
    HarnessInfinityEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exchange your hand and graveyard.<br>";
    }

    private HarnessInfinityEffect(HarnessInfinityEffect effect) {
        super((OneShotEffect)effect);
    }

    public HarnessInfinityEffect copy() {
        return new HarnessInfinityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl hand = new CardsImpl((Collection)player.getHand());
        CardsImpl graveyard = new CardsImpl((Collection)player.getGraveyard());
        player.moveCards((Cards)hand, Zone.GRAVEYARD, source, game);
        player.moveCards((Cards)graveyard, Zone.HAND, source, game);
        return true;
    }
}

