/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.HashSet;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;

class HarshMercyEffect
extends OneShotEffect {
    HarshMercyEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Each player chooses a creature type. Destroy all creatures that aren't of a type chosen this way. They can't be regenerated.";
    }

    private HarshMercyEffect(HarshMercyEffect effect) {
        super((OneShotEffect)effect);
    }

    public HarshMercyEffect copy() {
        return new HarshMercyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            HashSet<String> chosenTypes = new HashSet<String>();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                ChoiceCreatureType typeChoice = new ChoiceCreatureType(game, source);
                if (player != null && !player.choose(Outcome.DestroyPermanent, (Choice)typeChoice, game)) continue;
                game.informPlayers(sourceObject.getIdName() + ": " + player.getLogName() + " has chosen " + typeChoice.getChoiceKey());
                chosenTypes.add(typeChoice.getChoiceKey());
            }
            FilterCreaturePermanent filter = new FilterCreaturePermanent("creatures");
            for (String type : chosenTypes) {
                filter.add(Predicates.not((Predicate)SubType.byDescription((String)type).getPredicate()));
            }
            return new DestroyAllEffect((FilterPermanent)filter, true).apply(game, source);
        }
        return false;
    }
}

