/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.mana.AddManaOfAnyColorEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ManaEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;

class HarvestMageReplacementEffect
extends ReplacementEffectImpl {
    HarvestMageReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.Neutral);
        this.staticText = "Until end of turn, if you tap a land for mana, it produces one mana of a color of your choice instead of any other type and amount";
    }

    private HarvestMageReplacementEffect(HarvestMageReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public HarvestMageReplacementEffect copy() {
        return new HarvestMageReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ManaEvent manaEvent = (ManaEvent)event;
        Mana mana = manaEvent.getMana();
        if (game != null && game.inCheckPlayableState()) {
            mana.setToMana(new Mana(0, 0, 0, 0, 0, 0, 1, 0));
            return false;
        }
        new AddManaOfAnyColorEffect().apply(game, source);
        mana.setToMana(new Mana(0, 0, 0, 0, 0, 0, 0, 0));
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = ((TappedForManaEvent)event).getPermanent();
        return permanent != null && permanent.isLand(game) && permanent.isControlledBy(source.getControllerId());
    }
}

