/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.h.HaukensInsightLookEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class HaukensInsightExileEffect
extends OneShotEffect {
    HaukensInsightExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of your library face down. You may look at that card for as long as it remains exiled";
    }

    private HaukensInsightExileEffect(HaukensInsightExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public HaukensInsightExileEffect copy() {
        return new HaukensInsightExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (card = controller.getLibrary().getFromTop(game)) != null) {
            UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
            MageObject sourceObject = source.getSourceObject(game);
            String exileName = sourceObject == null ? null : sourceObject.getIdName();
            card.setFaceDown(true, game);
            controller.moveCardsToExile(card, source, game, false, exileId, exileName);
            if (game.getState().getZone(card.getId()) == Zone.EXILED) {
                card.setFaceDown(true, game);
                HaukensInsightLookEffect effect = new HaukensInsightLookEffect(controller.getId());
                effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
                game.addEffect((ContinuousEffect)effect, source);
                return true;
            }
        }
        return false;
    }
}

