/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.h.HaukensInsightWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class HaukensInsightPlayEffect
extends AsThoughEffectImpl {
    HaukensInsightPlayEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.PlayForFree);
        this.staticText = "Once during each of your turns, you may play a land or cast a spell from among the cards exiled with this permanent without paying its mana cost";
    }

    private HaukensInsightPlayEffect(HaukensInsightPlayEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public HaukensInsightPlayEffect copy() {
        return new HaukensInsightPlayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (affectedControllerId.equals(source.getControllerId()) && game.isActivePlayer(source.getControllerId())) {
            Player controller = game.getPlayer(source.getControllerId());
            HaukensInsightWatcher watcher = (HaukensInsightWatcher)game.getState().getWatcher(HaukensInsightWatcher.class);
            Permanent sourceObject = game.getPermanent(source.getSourceId());
            if (controller != null && watcher != null && sourceObject != null && !watcher.isAbilityUsed(new MageObjectReference((MageObject)sourceObject, game))) {
                UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)game.getState().getZoneChangeCounter(source.getSourceId()));
                ExileZone exileZone = game.getExile().getExileZone(exileId);
                if (exileZone != null && exileZone.contains((Object)CardUtil.getMainCardId((Game)game, (UUID)objectId))) {
                    this.allowCardToPlayWithoutMana(objectId, source, affectedControllerId, MageIdentifier.HaukensInsightWatcher, game);
                    return true;
                }
            }
        }
        return false;
    }
}

