/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.HashSet;
import java.util.Set;
import mage.MageIdentifier;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class HaukensInsightWatcher
extends Watcher {
    private final Set<MageObjectReference> usedFrom = new HashSet<MageObjectReference>();

    public HaukensInsightWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if ((event.getType() == GameEvent.EventType.SPELL_CAST || event.getType() == GameEvent.EventType.LAND_PLAYED) && event.hasApprovingIdentifier(MageIdentifier.HaukensInsightWatcher)) {
            this.usedFrom.add(event.getApprovingObject().getApprovingMageObjectReference());
        }
    }

    public void reset() {
        super.reset();
        this.usedFrom.clear();
    }

    public boolean isAbilityUsed(MageObjectReference mor) {
        return this.usedFrom.contains(mor);
    }
}

