/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HauntwoodsShriekerEffect
extends OneShotEffect {
    HauntwoodsShriekerEffect() {
        super(Outcome.Benefit);
        this.staticText = "Reveal target face-down permanent. If it's a creature card, you may turn it face up";
    }

    private HauntwoodsShriekerEffect(HauntwoodsShriekerEffect effect) {
        super((OneShotEffect)effect);
    }

    public HauntwoodsShriekerEffect copy() {
        return new HauntwoodsShriekerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        MageObject mageObject = game.getObject(source);
        if (player == null || mageObject == null) {
            return false;
        }
        Permanent faceDownPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (faceDownPermanent != null) {
            Card trueCard = (Card)faceDownPermanent.getBasicMageObject();
            player.revealCards(source, (Cards)new CardsImpl((Card)faceDownPermanent), game);
            if (trueCard.isCreature() && player.chooseUse(faceDownPermanent.getControllerId() == source.getControllerId() ? Outcome.Benefit : Outcome.Detriment, "Turn " + trueCard.getName() + " face up?", source, game)) {
                return faceDownPermanent.turnFaceUp(source, game, source.getControllerId());
            }
        } else {
            return false;
        }
        return true;
    }
}

