/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnFromGraveyardToHandTargetEffect;
import mage.abilities.mana.ColorlessManaAbility;
import mage.abilities.mana.ConditionalAnyColorManaAbility;
import mage.abilities.mana.builder.ConditionalManaBuilder;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.h.DragonCreatureCardPredicate;
import mage.cards.h.HavenOfTheSpiritManaBuilder;
import mage.cards.h.UginPlaneswalkerCardPredicate;
import mage.constants.CardType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

public final class HavenOfTheSpiritDragon
extends CardImpl {
    private static final FilterCard filter = new FilterCard("Dragon creature card or Ugin planeswalker card from your graveyard");

    public HavenOfTheSpiritDragon(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.LAND}, "");
        this.addAbility((Ability)new ColorlessManaAbility());
        this.addAbility((Ability)new ConditionalAnyColorManaAbility((Cost)new TapSourceCost(), 1, (ConditionalManaBuilder)new HavenOfTheSpiritManaBuilder(), true));
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new ReturnFromGraveyardToHandTargetEffect(), (Cost)new ManaCostsImpl("{2}"));
        ability.addCost((Cost)new TapSourceCost());
        ability.addCost((Cost)new SacrificeSourceCost());
        ability.addTarget((Target)new TargetCardInYourGraveyard(filter));
        this.addAbility((Ability)ability);
    }

    private HavenOfTheSpiritDragon(HavenOfTheSpiritDragon card) {
        super((CardImpl)card);
    }

    public HavenOfTheSpiritDragon copy() {
        return new HavenOfTheSpiritDragon(this);
    }

    static {
        filter.add(Predicates.or((Predicate)new DragonCreatureCardPredicate(), (Predicate)new UginPlaneswalkerCardPredicate()));
    }
}

