/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HavengulLichEffect
extends ContinuousEffectImpl {
    private final UUID cardId;

    public HavengulLichEffect(UUID cardId) {
        super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.cardId = cardId;
    }

    private HavengulLichEffect(HavengulLichEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.cardId = effect.cardId;
    }

    public HavengulLichEffect copy() {
        return new HavengulLichEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        Card card = game.getCard(this.cardId);
        if (permanent != null && card != null) {
            for (ActivatedAbility ability : card.getAbilities(game).getActivatedAbilities(Zone.BATTLEFIELD)) {
                permanent.addAbility((Ability)ability, source.getSourceId(), game, true);
            }
        }
        return false;
    }
}

