/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

class HazduhrTheAbbotRedirectDamageEffect
extends RedirectionEffect {
    public HazduhrTheAbbotRedirectDamageEffect(Duration duration) {
        super(duration, 0, RedirectionEffect.UsageType.ACCORDING_DURATION);
        this.staticText = "The next X damage that would be dealt this turn to target white creature you control is dealt to {this} instead";
    }

    private HazduhrTheAbbotRedirectDamageEffect(HazduhrTheAbbotRedirectDamageEffect effect) {
        super((RedirectionEffect)effect);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.amountToRedirect = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
    }

    public HazduhrTheAbbotRedirectDamageEffect copy() {
        return new HazduhrTheAbbotRedirectDamageEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || !event.getTargetId().equals(this.getTargetPointer().getFirst(game, source)) || event.getTargetId() == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent();
        target.add(source.getSourceId(), game);
        this.redirectTarget = target;
        return true;
    }
}

