/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HealTheScarsEffect
extends OneShotEffect {
    HealTheScarsEffect() {
        super(Outcome.GainLife);
        this.staticText = "You gain life equal to that creature's toughness";
    }

    private HealTheScarsEffect(HealTheScarsEffect effect) {
        super((OneShotEffect)effect);
    }

    public HealTheScarsEffect copy() {
        return new HealTheScarsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent != null) {
            Player player = game.getPlayer(source.getControllerId());
            if (player != null) {
                player.gainLife(permanent.getToughness().getValue(), game, source);
            }
            return true;
        }
        return false;
    }
}

