/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.HashSet;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.watchers.common.BlockedThisTurnWatcher;
import mage.watchers.common.WasBlockedThisTurnWatcher;

class HeatStrokeEffect
extends OneShotEffect {
    HeatStrokeEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "destroy each creature that blocked or was blocked this turn";
    }

    private HeatStrokeEffect(HeatStrokeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        BlockedThisTurnWatcher blockedWatcher = (BlockedThisTurnWatcher)game.getState().getWatcher(BlockedThisTurnWatcher.class);
        WasBlockedThisTurnWatcher wasBlockedThisTurnWatcher = (WasBlockedThisTurnWatcher)game.getState().getWatcher(WasBlockedThisTurnWatcher.class);
        HashSet inROI = new HashSet(game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game));
        boolean toRet = false;
        HashSet toDestroy = new HashSet();
        if (blockedWatcher != null) {
            toDestroy.addAll(blockedWatcher.getBlockedThisTurnCreatures());
        }
        if (wasBlockedThisTurnWatcher != null) {
            toDestroy.addAll(wasBlockedThisTurnWatcher.getWasBlockedThisTurnCreatures());
        }
        for (MageObjectReference mor : toDestroy) {
            Permanent permanent = mor.getPermanent(game);
            if (permanent == null || !permanent.isCreature(game) || !inROI.contains(permanent)) continue;
            permanent.destroy(source, game, false);
            toRet = true;
        }
        return toRet;
    }

    public HeatStrokeEffect copy() {
        return new HeatStrokeEffect(this);
    }
}

