/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HeatWaveEffect2
extends ReplacementEffectImpl {
    HeatWaveEffect2() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Nonblue creatures can't block creatures you control unless their controller pays 1 life for each blocking creature they control";
    }

    private HeatWaveEffect2(HeatWaveEffect2 effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(event.getPlayerId());
        if (player == null) {
            return false;
        }
        Permanent blocker = game.getPermanent(event.getSourceId());
        if (blocker == null || blocker.getColor(game).isBlue()) {
            return false;
        }
        Permanent attacker = game.getPermanent(event.getTargetId());
        if (attacker == null || !attacker.isControlledBy(source.getControllerId())) {
            return false;
        }
        PayLifeCost cost = new PayLifeCost(1);
        if (cost.canPay(source, source, player.getId(), game) && player.chooseUse(Outcome.Benefit, "Pay 1 life to declare blocker?", source, game)) {
            return !cost.pay(source, game, source, player.getId(), true, (Cost)cost);
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARE_BLOCKER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return true;
    }

    public HeatWaveEffect2 copy() {
        return new HeatWaveEffect2(this);
    }
}

