/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.h.HedonistsTroveWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;

class HedonistsTroveCastNonlandCardsEffect
extends AsThoughEffectImpl {
    HedonistsTroveCastNonlandCardsEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "You may cast spells from among cards exiled with {this}. You can't cast more than one spell this way each turn.";
    }

    private HedonistsTroveCastNonlandCardsEffect(HedonistsTroveCastNonlandCardsEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public HedonistsTroveCastNonlandCardsEffect copy() {
        return new HedonistsTroveCastNonlandCardsEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        HedonistsTroveWatcher watcher = (HedonistsTroveWatcher)game.getState().getWatcher(HedonistsTroveWatcher.class);
        if (watcher == null || !watcher.checkPlayer(affectedControllerId, source, game)) {
            return false;
        }
        Card cardToCheck = game.getCard(objectId);
        UUID exileId = (UUID)game.getState().getValue(source.getSourceId().toString());
        ExileZone exileZone = game.getExile().getExileZone(exileId);
        return cardToCheck != null && !cardToCheck.isLand(game) && source.isControlledBy(affectedControllerId) && exileZone != null && exileZone.contains((Object)cardToCheck.getMainCard().getId());
    }
}

