/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class HedronBladeTriggeredAbility
extends TriggeredAbilityImpl {
    HedronBladeTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect, false);
    }

    private HedronBladeTriggeredAbility(HedronBladeTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public HedronBladeTriggeredAbility copy() {
        return new HedronBladeTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_BLOCKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent equippedPermanent;
        Permanent equipment = game.getPermanentOrLKIBattlefield(this.getSourceId());
        if (equipment != null && equipment.getAttachedTo() != null && (equippedPermanent = game.getPermanentOrLKIBattlefield(equipment.getAttachedTo())) != null && equippedPermanent.isAttacking()) {
            for (CombatGroup group : game.getCombat().getGroups()) {
                if (!group.getAttackers().contains(equippedPermanent.getId())) continue;
                for (UUID blockerId : group.getBlockers()) {
                    Permanent blocker = game.getPermanent(blockerId);
                    if (blocker == null || !blocker.getColor(game).isColorless()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever equipped creature becomes blocked by one or more colorless creatures, it gains deathtouch until end of turn.";
    }
}

