/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;
import mage.watchers.common.CardsDrawnThisTurnWatcher;

class HeliodTheWarpedEclipseEffect
extends CostModificationEffectImpl {
    HeliodTheWarpedEclipseEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "spells you cast cost {1} less to cast for each card your opponents have drawn this turn";
    }

    private HeliodTheWarpedEclipseEffect(HeliodTheWarpedEclipseEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardsDrawnThisTurnWatcher watcher = (CardsDrawnThisTurnWatcher)game.getState().getWatcher(CardsDrawnThisTurnWatcher.class);
        if (watcher == null) {
            return false;
        }
        int amount = game.getOpponents(source.getControllerId()).stream().mapToInt(arg_0 -> ((CardsDrawnThisTurnWatcher)watcher).getCardsDrawnThisTurn(arg_0)).sum();
        if (amount < 1) {
            return false;
        }
        CardUtil.adjustCost((SpellAbility)((SpellAbility)abilityToModify), (int)amount);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof SpellAbility && game.getCard(abilityToModify.getSourceId()) != null && abilityToModify.isControlledBy(source.getControllerId());
    }

    public HeliodTheWarpedEclipseEffect copy() {
        return new HeliodTheWarpedEclipseEffect(this);
    }
}

