/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageControllerEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HellfireEffect
extends OneShotEffect {
    HellfireEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all nonblack creatures. {this} deals X plus 3 damage to you, where X is the number of creatures that died this way";
    }

    private HellfireEffect(HellfireEffect effect) {
        super((OneShotEffect)effect);
    }

    public HellfireEffect copy() {
        return new HellfireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int destroyedCreature = 0;
            for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES_NON_BLACK, controller.getId(), game)) {
                if (!creature.destroy(source, game, false) || game.getState().getZone(creature.getId()) != Zone.GRAVEYARD) continue;
                ++destroyedCreature;
            }
            if (destroyedCreature > 0) {
                new DamageControllerEffect(destroyedCreature + 3).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

