/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInGraveyard;

class HelmOfObedienceEffect
extends OneShotEffect {
    HelmOfObedienceEffect() {
        super(Outcome.Detriment);
        this.staticText = "Target opponent mills a card, then repeats this process until a creature card or X cards have been put into their graveyard this way, whichever comes first. If one or more creature cards were put into that graveyard this way, sacrifice {this} and put one of them onto the battlefield under your control. X can't be 0";
    }

    private HelmOfObedienceEffect(HelmOfObedienceEffect effect) {
        super((OneShotEffect)effect);
    }

    public HelmOfObedienceEffect copy() {
        return new HelmOfObedienceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        Player targetOpponent = game.getPlayer(source.getFirstTarget());
        int max = GetXValue.instance.calculate(game, source, (Effect)this);
        if (targetOpponent == null || controller == null || max < 1) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        while (targetOpponent.getLibrary().hasCards()) {
            cards.addAll((Collection)targetOpponent.millCards(1, source, game));
            cards.retainZone(Zone.GRAVEYARD, game);
            if (cards.size() < max && cards.count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game) <= 0) continue;
        }
        switch (cards.count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game)) {
            case 0: {
                return true;
            }
            case 1: {
                card = cards.getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game).stream().findFirst().orElse(null);
                break;
            }
            default: {
                TargetCardInGraveyard target = new TargetCardInGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE);
                target.withNotTarget(true);
                controller.choose(Outcome.PutCreatureInPlay, (Cards)cards, (TargetCard)target, source, game);
                card = game.getCard(target.getFirstTarget());
            }
        }
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent != null) {
            permanent.sacrifice(source, game);
        }
        controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        return true;
    }
}

