/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HelmOfTheHostEffect
extends OneShotEffect {
    HelmOfTheHostEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create a token that's a copy of equipped creature, except the token isn't legendary. That token gains haste.";
    }

    private HelmOfTheHostEffect(HelmOfTheHostEffect effect) {
        super((OneShotEffect)effect);
    }

    public HelmOfTheHostEffect copy() {
        return new HelmOfTheHostEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent equipment = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (equipment == null) {
            return true;
        }
        Permanent creature = game.getPermanentOrLKIBattlefield(equipment.getAttachedTo());
        if (creature == null) {
            return true;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), null, true);
        effect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
        effect.setIsntLegendary(true);
        return effect.apply(game, source);
    }
}

