/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.HashSet;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.BlitzAbility;
import mage.cards.Card;
import mage.constants.CommanderCardType;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class HenzieToolboxTorreGainBlitzEffect
extends ContinuousEffectImpl {
    private static final FilterCreatureCard filter = new FilterCreatureCard("creature spell you cast with mana value 4 or greater");

    HenzieToolboxTorreGainBlitzEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Each creature spell you cast with mana value 4 or greater has blitz. The blitz cost is equal to its mana cost. <i>(You may choose to cast that spell for its blitz cost. If you do, it gains haste and \"When this creature dies, draw a card.\" Sacrifice it at the beginning of the next end step.)</i>";
    }

    private HenzieToolboxTorreGainBlitzEffect(HenzieToolboxTorreGainBlitzEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        HashSet cardsToGainBlitz = new HashSet();
        cardsToGainBlitz.addAll(controller.getHand().getCards((FilterCard)filter, game));
        cardsToGainBlitz.addAll(controller.getGraveyard().getCards((FilterCard)filter, game));
        controller.getLibrary().getCards(game).stream().filter(c -> filter.match(c, game)).forEach(cardsToGainBlitz::add);
        game.getExile().getCardsInRange(game, controller.getId()).stream().filter(c -> filter.match(c, game)).forEach(cardsToGainBlitz::add);
        game.getCommanderCardsFromCommandZone(controller, CommanderCardType.ANY).stream().filter(card -> filter.match(card, game)).forEach(cardsToGainBlitz::add);
        game.getStack().stream().filter(Spell.class::isInstance).filter(s -> s.isControlledBy(controller.getId())).filter(s -> filter.match((Card)((Spell)s), game)).map(s -> game.getCard(s.getSourceId())).filter(Objects::nonNull).forEach(cardsToGainBlitz::add);
        for (Card card2 : cardsToGainBlitz) {
            if (card2.getManaCost().getText().isEmpty()) continue;
            BlitzAbility ability = new BlitzAbility(card2, card2.getManaCost().getText());
            ability.setSourceId(card2.getId());
            ability.setControllerId(card2.getControllerOrOwnerId());
            game.getState().addOtherAbility(card2, (Ability)ability);
        }
        return true;
    }

    public HenzieToolboxTorreGainBlitzEffect copy() {
        return new HenzieToolboxTorreGainBlitzEffect(this);
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.OR_GREATER, 4));
    }
}

