/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counters;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class HeraldOfIlhargEffect
extends OneShotEffect {
    HeraldOfIlhargEffect() {
        super(Outcome.Benefit);
        this.staticText = "If that spell has mana value 5 or greater, {this} deals damage equal to the number of counters on it to each opponent";
    }

    private HeraldOfIlhargEffect(HeraldOfIlhargEffect effect) {
        super((OneShotEffect)effect);
    }

    public HeraldOfIlhargEffect copy() {
        return new HeraldOfIlhargEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int count = Optional.ofNullable(source.getSourcePermanentOrLKI(game)).map(permanent -> permanent.getCounters(game)).map(Counters::getTotalCount).orElse(0);
        Spell spell = (Spell)this.getValue("spellCast");
        if (count < 1 || spell == null || spell.getManaValue() < 5) {
            return false;
        }
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.damage(count, source, game);
        }
        return true;
    }
}

