/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeGroupEvent;

class HeroOfBretagardTriggeredAbility
extends TriggeredAbilityImpl {
    HeroOfBretagardTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
    }

    private HeroOfBretagardTriggeredAbility(HeroOfBretagardTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public HeroOfBretagardTriggeredAbility copy() {
        return new HeroOfBretagardTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE_GROUP;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeGroupEvent zEvent = (ZoneChangeGroupEvent)event;
        if (zEvent.getToZone() != Zone.EXILED) {
            return false;
        }
        int exiledCount = 0;
        if (zEvent.getFromZone() == Zone.BATTLEFIELD) {
            if (zEvent.getSource() != null && this.isControlledBy(zEvent.getSource().getControllerId())) {
                exiledCount += zEvent.getCards().size() + zEvent.getTokens().size();
            }
        } else if (zEvent.getFromZone() == Zone.HAND) {
            exiledCount = (int)((long)exiledCount + zEvent.getCards().stream().filter(card -> card != null && this.isControlledBy(card.getOwnerId())).count());
        }
        if (exiledCount > 0) {
            this.getEffects().clear();
            this.getEffects().add((Object)new AddCountersSourceEffect(CounterType.P1P1.createInstance(exiledCount)));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever one or more cards are put into exile from your hand or a spell or ability you control exiles one or more permanents from the battlefield, put that many +1/+1 counters on {this}.";
    }
}

