/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.ArrayList;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PreventDamageByTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterAttackingCreature;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HeroismEffect
extends OneShotEffect {
    private static final FilterAttackingCreature filter = new FilterAttackingCreature("attacking red creature");

    public HeroismEffect() {
        super(Outcome.Benefit);
        this.staticText = "For each attacking red creature, prevent all combat damage that would be dealt by that creature this turn unless its controller pays {2}{R}";
    }

    private HeroismEffect(HeroismEffect effect) {
        super((OneShotEffect)effect);
    }

    public HeroismEffect copy() {
        return new HeroismEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player player = game.getPlayer(game.getActivePlayerId());
            ManaCostsImpl cost = new ManaCostsImpl("{2}{R}");
            ArrayList<Permanent> permanentsToPrevent = new ArrayList<Permanent>();
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, game.getActivePlayerId(), game)) {
                cost.clearPaid();
                String message = "Pay " + cost.getText() + "? If you don't, " + permanent.getLogName() + "'s combat damage will be prevented this turn.";
                if (player == null) continue;
                if (player.chooseUse(Outcome.Neutral, message, source, game)) {
                    if (cost.pay(source, game, source, player.getId(), false, null)) {
                        game.informPlayers(player.getLogName() + " paid " + cost.getText() + " for " + permanent.getLogName());
                        continue;
                    }
                    game.informPlayers(player.getLogName() + " didn't pay " + cost.getText() + " for " + permanent.getLogName());
                    permanentsToPrevent.add(permanent);
                    continue;
                }
                game.informPlayers(player.getLogName() + " didn't pay " + cost.getText() + " for " + permanent.getLogName());
                permanentsToPrevent.add(permanent);
            }
            for (Permanent permanent : permanentsToPrevent) {
                PreventDamageByTargetEffect effect = new PreventDamageByTargetEffect(Duration.EndOfTurn, true);
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.RED));
    }
}

