/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class HiddenStringsEffect
extends OneShotEffect {
    HiddenStringsEffect() {
        super(Outcome.Tap);
        this.staticText = "You may tap or untap target permanent, then you may tap or untap another target permanent";
    }

    private HiddenStringsEffect(HiddenStringsEffect effect) {
        super((OneShotEffect)effect);
    }

    public HiddenStringsEffect copy() {
        return new HiddenStringsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            for (UUID targetId : ((Target)source.getTargets().get(0)).getTargets()) {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent == null) continue;
                if (permanent.isTapped()) {
                    if (!player.chooseUse(Outcome.Untap, "Untap " + permanent.getName() + '?', source, game)) continue;
                    permanent.untap(game);
                    continue;
                }
                if (!player.chooseUse(Outcome.Tap, "Tap " + permanent.getName() + '?', source, game)) continue;
                permanent.tap(source, game);
            }
            return true;
        }
        return false;
    }
}

