/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class HidetsuguAndKairiEffect
extends OneShotEffect {
    HidetsuguAndKairiEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of your library. Target opponent loses life equal to its mana value. If it's an instant or sorcery card, you may cast it without paying its mana cost";
    }

    private HidetsuguAndKairiEffect(HidetsuguAndKairiEffect effect) {
        super((OneShotEffect)effect);
    }

    public HidetsuguAndKairiEffect copy() {
        return new HidetsuguAndKairiEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null || opponent == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null || !player.moveCardsToExile(card, source, game, true, null, "")) {
            return false;
        }
        opponent.loseLife(card.getManaValue(), game, source, false);
        return !card.isInstantOrSorcery(game) || CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Card)card);
    }
}

