/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.h.HinataDawnCrownedEffectUtility;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class HinataDawnCrownedOwnEffect
extends CostModificationEffectImpl {
    HinataDawnCrownedOwnEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral, CostModificationType.REDUCE_COST);
        this.staticText = "Spells you cast cost {1} less to cast for each target";
    }

    private HinataDawnCrownedOwnEffect(HinataDawnCrownedOwnEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public HinataDawnCrownedOwnEffect copy() {
        return new HinataDawnCrownedOwnEffect(this);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost((Ability)abilityToModify, (int)HinataDawnCrownedEffectUtility.getTargetCount(game, abilityToModify));
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof SpellAbility && abilityToModify.isControlledBy(source.getControllerId());
    }
}

